/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.web;

import javax.servlet.ServletContext;
import net.sourceforge.wurfl.core.CustomWURFLHolder;
import net.sourceforge.wurfl.core.WURFLHolder;
import net.sourceforge.wurfl.core.WURFLManager;
import net.sourceforge.wurfl.core.WURFLUtils;
import net.sourceforge.wurfl.core.resource.WURFLResources;
import net.sourceforge.wurfl.core.resource.XMLResource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ServletContextWURFLHolder
implements WURFLHolder {
    public static final String WURFL = "wurfl";
    public static final String WURFL_PATCH = "wurflPatch";
    private WURFLHolder delegate;

    public ServletContextWURFLHolder(ServletContext servletContext) {
        this.delegate = this.createDelegate(servletContext);
    }

    private WURFLHolder createDelegate(ServletContext servletContext) {
        String mainPath = servletContext.getInitParameter(WURFL);
        Validate.notEmpty((String)mainPath, (String)"Please Specify a Valid Location for wurfl context parameter");
        String[] patchesPath = StringUtils.split((String)StringUtils.defaultString((String)servletContext.getInitParameter(WURFL_PATCH)), (String)" ,");
        XMLResource root = new XMLResource(servletContext.getResourceAsStream(mainPath));
        WURFLResources patches = new WURFLResources();
        for (int index = 0; index < patchesPath.length; ++index) {
            XMLResource patch = new XMLResource(servletContext.getResourceAsStream(patchesPath[index]));
            patches.add(patch);
        }
        CustomWURFLHolder wurflHolder = new CustomWURFLHolder(root, patches);
        return wurflHolder;
    }

    public WURFLManager getWURFLManager() {
        return this.delegate.getWURFLManager();
    }

    public WURFLUtils getWURFLUtils() {
        return this.delegate.getWURFLUtils();
    }
}

