/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.io.File;
import net.sourceforge.wurfl.core.DefaultDeviceProvider;
import net.sourceforge.wurfl.core.DefaultWURFLHolder;
import net.sourceforge.wurfl.core.DefaultWURFLManager;
import net.sourceforge.wurfl.core.DefaultWURFLService;
import net.sourceforge.wurfl.core.WURFLHolder;
import net.sourceforge.wurfl.core.WURFLManager;
import net.sourceforge.wurfl.core.WURFLUtils;
import net.sourceforge.wurfl.core.handlers.matchers.MatcherManager;
import net.sourceforge.wurfl.core.resource.DefaultWURFLModel;
import net.sourceforge.wurfl.core.resource.WURFLResource;
import net.sourceforge.wurfl.core.resource.WURFLResources;
import net.sourceforge.wurfl.core.resource.XMLResource;
import org.apache.commons.lang.Validate;

public class CustomWURFLHolder
implements WURFLHolder {
    private WURFLResource root;
    private WURFLResources patches;
    private WURFLHolder delegate;

    public CustomWURFLHolder(WURFLResource root, WURFLResources patches) {
        Validate.notNull((Object)root, (String)"The root resource is null");
        this.root = root;
        this.patches = patches;
        this.init();
    }

    public CustomWURFLHolder(WURFLResource root) {
        this(root, new WURFLResources());
    }

    public CustomWURFLHolder(String rootPath, String[] patchesPath) {
        Validate.notEmpty((String)rootPath, (String)"The rootPath is null");
        this.root = new XMLResource(rootPath);
        this.patches = new WURFLResources();
        for (int index = 0; patchesPath != null && index < patchesPath.length; ++index) {
            this.patches.add(new XMLResource(patchesPath[index]));
        }
        this.init();
    }

    public CustomWURFLHolder(String rootPath) {
        this(rootPath, new String[0]);
    }

    public CustomWURFLHolder(File rootFile, File[] patchesFile) {
        Validate.notNull((Object)rootFile, (String)"The rootFile is null");
        Validate.isTrue((boolean)rootFile.exists(), (String)"The rootFile does not exist");
        Validate.isTrue((boolean)rootFile.canRead(), (String)"The rootFile is not readable");
        this.root = new XMLResource(rootFile);
        this.patches = new WURFLResources();
        for (int index = 0; patchesFile != null && index < patchesFile.length; ++index) {
            Validate.notNull((Object)patchesFile[index], (String)"The pathFile is null");
            Validate.isTrue((boolean)patchesFile[index].exists(), (String)"The pathFile does not exist");
            Validate.isTrue((boolean)patchesFile[index].canRead(), (String)"The patchFile is not readable");
            this.patches.add(new XMLResource(patchesFile[index]));
        }
        this.init();
    }

    public CustomWURFLHolder(File rootFile) {
        this(rootFile, new File[0]);
    }

    protected void init() {
        DefaultWURFLModel model = new DefaultWURFLModel(this.root, this.patches);
        MatcherManager matcherManager = new MatcherManager(model);
        DefaultDeviceProvider deviceProvider = new DefaultDeviceProvider(model);
        DefaultWURFLService service = new DefaultWURFLService(matcherManager, deviceProvider);
        DefaultWURFLManager manager = new DefaultWURFLManager(service);
        WURFLUtils utils = new WURFLUtils(model, deviceProvider);
        this.createDelegate(manager, utils);
    }

    protected void createDelegate(WURFLManager manager, WURFLUtils utils) {
        this.delegate = new DefaultWURFLHolder(manager, utils);
    }

    public WURFLManager getWURFLManager() {
        return this.delegate.getWURFLManager();
    }

    public WURFLUtils getWURFLUtils() {
        return this.delegate.getWURFLUtils();
    }
}

