/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.wurfl.core.CapabilitiesHolder;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.MarkUp;
import net.sourceforge.wurfl.core.MarkupResolver;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDevice
implements Device,
Serializable {
    private static final long serialVersionUID = 101L;
    private static final Log LOG = LogFactory.getLog((Class)DefaultDevice.class);
    private final String id;
    private final String userAgent;
    private final CapabilitiesHolder capabilityHolder;
    private final MarkupResolver markupResolver;
    private transient MarkUp markUp;

    public DefaultDevice(ModelDevice root, CapabilitiesHolder capabilitiesHolder, MarkupResolver markupResolver) {
        Validate.notNull((Object)root, (String)"The root device must be not null");
        Validate.notNull((Object)capabilitiesHolder, (String)"The capabilitiesHolder must be not null");
        Validate.notNull((Object)markupResolver, (String)"The markupResolver must be not null");
        this.id = root.getID();
        this.userAgent = root.getUserAgent();
        this.capabilityHolder = capabilitiesHolder;
        this.markupResolver = markupResolver;
    }

    public String getId() {
        return this.id;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getCapability(String name) throws CapabilityNotDefinedException {
        return this.capabilityHolder.getCapabilityValue(name);
    }

    public Map getCapabilities() {
        return new HashMap(this.capabilityHolder.getAllCapabilities());
    }

    public MarkUp getMarkUp() {
        if (this.markUp == null) {
            LOG.trace((Object)"Resolving MarkUp for device...");
            this.markUp = this.markupResolver.getMarkupForDevice(this);
        }
        return this.markUp;
    }

    public boolean equals(Object obj) {
        EqualsBuilder eb = new EqualsBuilder();
        eb.appendSuper(this.getClass().isInstance(obj));
        if (eb.isEquals()) {
            DefaultDevice other = (DefaultDevice)obj;
            eb.append((Object)this.id, (Object)other.id);
        }
        return eb.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(63, 89).append(this.getClass()).append((Object)this.id).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.id).toString();
    }
}

