/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import net.sourceforge.wurfl.core.AbstractDeviceProvider;
import net.sourceforge.wurfl.core.CapabilitiesHolder;
import net.sourceforge.wurfl.core.CapabilitiesHolderFactory;
import net.sourceforge.wurfl.core.DefaultCapabilitiesHolderFactory;
import net.sourceforge.wurfl.core.DefaultDevice;
import net.sourceforge.wurfl.core.DefaultMarkupResolver;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.DeviceNotDefinedException;
import net.sourceforge.wurfl.core.MarkupResolver;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDeviceProvider
extends AbstractDeviceProvider {
    private static final Log LOG;
    private final MarkupResolver markupResolver;
    private final CapabilitiesHolderFactory capabilitiesHolderFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultDeviceProvider(WURFLModel model, CapabilitiesHolderFactory capabilitiesHolderFactory, MarkupResolver markupResolver) {
        super(model);
        Validate.notNull((Object)capabilitiesHolderFactory, (String)"capabilitiesHolderFactory must be not null.");
        Validate.notNull((Object)markupResolver, (String)"markupResolver must be not null.");
        this.capabilitiesHolderFactory = capabilitiesHolderFactory;
        this.markupResolver = markupResolver;
    }

    public DefaultDeviceProvider(WURFLModel model, CapabilitiesHolderFactory capabilitiesHolderFactory) {
        this(model, capabilitiesHolderFactory, new DefaultMarkupResolver());
    }

    public DefaultDeviceProvider(WURFLModel model, MarkupResolver markupResolver) {
        this(model, new DefaultCapabilitiesHolderFactory(model), markupResolver);
    }

    public DefaultDeviceProvider(WURFLModel model) {
        this(model, new DefaultCapabilitiesHolderFactory(model), new DefaultMarkupResolver());
    }

    public Device getDevice(String id) throws DeviceNotDefinedException {
        Validate.notEmpty((String)id, (String)"The id must be not null String");
        ModelDevice modelDevice = this.getModelDevice(id);
        if (!$assertionsDisabled && modelDevice == null) {
            throw new AssertionError((Object)"modelDevice is null");
        }
        CapabilitiesHolder capabilityHolder = this.createCapabilitiesHolder(modelDevice);
        DefaultDevice device = new DefaultDevice(modelDevice, capabilityHolder, this.markupResolver);
        if (LOG.isTraceEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Return device: ").append((Object)device);
            LOG.trace((Object)logBuilder.toString());
        }
        return device;
    }

    protected CapabilitiesHolder createCapabilitiesHolder(ModelDevice modelDevice) {
        return this.capabilitiesHolderFactory.create(modelDevice);
    }

    static {
        $assertionsDisabled = !DefaultDeviceProvider.class.desiredAssertionStatus();
        LOG = LogFactory.getLog((Class)DefaultDeviceProvider.class);
    }
}

