/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.io.Serializable;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.MarkUp;
import net.sourceforge.wurfl.core.MarkupResolver;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMarkupResolver
implements MarkupResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((Class)DefaultMarkupResolver.class);

    public MarkUp getMarkupForDevice(Device device) {
        MarkUp markUp = null;
        String xhtmlSupportLevel = "-1";
        String preferredMarkup = "wml_1_1";
        try {
            xhtmlSupportLevel = device.getCapability("xhtml_support_level");
            preferredMarkup = device.getCapability("preferred_markup");
        }
        catch (CapabilityNotDefinedException e) {
            LOG.fatal((Object)("It is not possible getting markUp from capabilities: " + e.getLocalizedMessage()));
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        markUp = Integer.valueOf(xhtmlSupportLevel) >= 3 ? MarkUp.XHTML_ADVANCED : (Integer.valueOf(xhtmlSupportLevel) >= 1 ? MarkUp.XHTML_SIMPLE : (preferredMarkup.indexOf("imode") != -1 ? MarkUp.CHTML : MarkUp.WML));
        if (LOG.isTraceEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Device[id: ").append(device.getId()).append(", ").append("xhtml_support_level").append(": ").append(xhtmlSupportLevel).append(", ").append("preferred_markup").append(": ").append(preferredMarkup).append("] returns markup: ").append((Object)markUp);
            LOG.trace((Object)logBuilder.toString());
        }
        return markUp;
    }
}

