/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.DeviceProvider;
import net.sourceforge.wurfl.core.WURFLService;
import net.sourceforge.wurfl.core.cache.CacheProvider;
import net.sourceforge.wurfl.core.cache.LRUMapCacheProvider;
import net.sourceforge.wurfl.core.handlers.matchers.MatcherManager;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWURFLService
implements WURFLService {
    private static final Log LOG;
    private CacheProvider cacheProvider;
    private MatcherManager matcherManager;
    private DeviceProvider deviceProvider;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultWURFLService(MatcherManager matcherManager, DeviceProvider deviceProvider, CacheProvider cacheProvider) {
        this.matcherManager = matcherManager;
        this.deviceProvider = deviceProvider;
        this.cacheProvider = cacheProvider;
        LOG.info((Object)"DefaultWURFLService created");
    }

    public DefaultWURFLService(MatcherManager matcherManager, DeviceProvider deviceProvider) {
        this(matcherManager, deviceProvider, new LRUMapCacheProvider());
    }

    public Device getDeviceForRequest(WURFLRequest request) {
        Validate.notNull((Object)request, (String)"The request is null");
        Object deviceKey = this.createDeviceKey(request);
        Device device = (Device)this.cacheProvider.get(deviceKey);
        if (LOG.isDebugEnabled() && device != null) {
            LOG.debug((Object)("Found cached device: " + device));
        }
        if (device == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not found device cached with key: " + deviceKey + ", matching..."));
            }
            String deviceId = this.matcherManager.matchRequest(request);
            device = this.deviceProvider.getDevice(deviceId);
            this.cacheProvider.put(deviceKey, device);
        }
        if (!$assertionsDisabled && device == null) {
            throw new AssertionError();
        }
        return device;
    }

    protected Object createDeviceKey(WURFLRequest request) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError((Object)"The request is null");
        }
        return new StrBuilder(request.getUserAgent()).append(request.getUserAgentProfile()).toString();
    }

    static {
        $assertionsDisabled = !DefaultWURFLService.class.desiredAssertionStatus();
        LOG = LogFactory.getLog((Class)DefaultWURFLService.class);
    }
}

