/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.wurfl.core.CapabilitiesHolder;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HierarchyCapabilitiesHolder
implements CapabilitiesHolder,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG;
    private final List hierarchy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HierarchyCapabilitiesHolder(List hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getCapabilityValue(String capabilityName) throws CapabilityNotDefinedException {
        String capabilityValue = null;
        if (LOG.isTraceEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Finding capability ").append(capabilityName).append(" accross the device's hierachy...");
            LOG.trace((Object)logBuilder.toString());
        }
        ReverseListIterator hIt = new ReverseListIterator(this.hierarchy);
        while (hIt.hasNext() && capabilityValue == null) {
            ModelDevice looperDevice = (ModelDevice)hIt.next();
            if (looperDevice.defineCapability(capabilityName)) {
                capabilityValue = looperDevice.getCapability(capabilityName);
                continue;
            }
            if (!"generic".equals(looperDevice.getID())) continue;
            throw new CapabilityNotDefinedException(capabilityName);
        }
        if (!$assertionsDisabled && capabilityValue == null) {
            throw new AssertionError();
        }
        return capabilityValue;
    }

    public Map getAllCapabilities() {
        HashMap capabilities = new HashMap();
        LOG.trace((Object)"Building all capability map...");
        Iterator iterator = this.hierarchy.iterator();
        while (iterator.hasNext()) {
            ModelDevice device = (ModelDevice)iterator.next();
            capabilities.putAll(device.getCapabilities());
        }
        return capabilities;
    }

    static {
        $assertionsDisabled = !HierarchyCapabilitiesHolder.class.desiredAssertionStatus();
        LOG = LogFactory.getLog((Class)HierarchyCapabilitiesHolder.class);
    }
}

