/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.cache;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import net.sourceforge.wurfl.core.cache.CacheProvider;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HashMapCacheProvider
implements CacheProvider {
    private Map cache;
    private int initialCapacity = 6000;
    private float loadFactor = 0.75f;
    private int concurrentWrites = 16;
    private static final Log LOG = LogFactory.getLog((Class)HashMapCacheProvider.class);

    public HashMapCacheProvider() {
        this(60000);
    }

    public HashMapCacheProvider(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMapCacheProvider(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public HashMapCacheProvider(int initialCapacity, float loadFactor, int concurrentWrites) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.concurrentWrites = concurrentWrites;
        this.cache = this.createCache();
        if (LOG.isInfoEnabled()) {
            StringBuffer logBuffer = new StringBuffer("Created HashMapCacheProvider with initial capacity: ");
            logBuffer.append(initialCapacity);
            logBuffer.append(" load factor: ");
            logBuffer.append(loadFactor);
            logBuffer.append(" concurrent writes: ");
            logBuffer.append(concurrentWrites);
            LOG.info((Object)logBuffer.toString());
        }
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public int getConcurrentWrites() {
        return this.concurrentWrites;
    }

    public void clear() {
        this.cache.clear();
        LOG.debug((Object)"Cache erased");
    }

    public Object get(Object key) {
        Validate.notNull((Object)key, (String)"The key is null");
        Object target = this.cache.get(key);
        if (LOG.isDebugEnabled()) {
            if (target == null) {
                LOG.debug((Object)("The key: " + key + " is not in cache"));
            } else {
                LOG.debug((Object)("Retrieving from cache object: " + target + " by key: " + key));
            }
        }
        return target;
    }

    public void put(Object key, Object target) {
        Validate.notNull((Object)key, (String)"The key is null");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing object: " + target + " with key: " + key));
        }
        this.cache.put(key, target);
    }

    protected Map createCache() {
        ConcurrentHashMap cacheMap = new ConcurrentHashMap(this.initialCapacity, this.loadFactor, this.concurrentWrites);
        return cacheMap;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.cache).toString();
    }
}

