/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.Matcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.UserAgentUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMatcher
implements Matcher {
    private final Handler handler;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Log undetected = LogFactory.getLog((String)"net.sourceforge.wurfl.core.UNDETECTED_WURFL_DEVICES");
    protected final Log detected = LogFactory.getLog((String)"net.sourceforge.wurfl.core.DETECTED_WURFL_DEVICES");
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractMatcher(Handler handler) {
        this.handler = handler;
    }

    public boolean canHandle(WURFLRequest request) {
        return this.handler.canHandle(request.getUserAgent());
    }

    public final String match(WURFLRequest request, FilteredDevices filteredDevices) {
        String userAgent = request.getUserAgent();
        if (StringUtils.isBlank((String)userAgent)) {
            return "generic";
        }
        this.log("Applying Direct Match on UA: " + userAgent);
        String deviceID = filteredDevices.getDevice(userAgent);
        if (!this.isBlankOrGeneric(deviceID)) {
            return deviceID;
        }
        this.log("Applying Conclusive Match on UA: " + userAgent);
        deviceID = this.applyConclusiveMatch(request, filteredDevices);
        if (!this.isBlankOrGeneric(deviceID)) {
            return deviceID;
        }
        this.log("Applying Recovery Match on UA: " + userAgent);
        deviceID = this.applyRecoveryMatch(request, filteredDevices);
        if (!this.isBlankOrGeneric(deviceID)) {
            return deviceID;
        }
        this.log("Applying CatchAll Recovery Match on UA: " + userAgent);
        deviceID = this.applyCatchAllRecoveryMatch(request, filteredDevices);
        if (!$assertionsDisabled && deviceID == null) {
            throw new AssertionError();
        }
        return deviceID;
    }

    private void log(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)message);
        }
    }

    protected String applyConclusiveMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        String normalizedUserAgent = this.handler.normalize(request.getUserAgent());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Matching UA: " + normalizedUserAgent + " against devices: " + filteredDevices.getUserAgents()));
        }
        String match = this.lookForMatchingUserAgent(filteredDevices.getUserAgents(), normalizedUserAgent);
        if (this.undetected.isDebugEnabled() && match == null) {
            this.undetected.debug((Object)(request.getUserAgent() + ":" + request.getUserAgentProfile()));
        }
        String deviceID = "generic";
        if (null != match) {
            if (this.detected.isDebugEnabled()) {
                this.detected.debug((Object)(request.getUserAgent() + ":" + request.getUserAgentProfile() + ":" + match));
            }
            deviceID = filteredDevices.getDevice(match);
        }
        if (deviceID == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("filteredDevices do not contain UA: " + match + " return generic"));
            }
            deviceID = "generic";
        }
        return deviceID;
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        int tollerance = net.sourceforge.wurfl.core.utils.StringUtils.firstSlash(userAgent);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying RIS(FS) UA: " + userAgent));
        }
        return net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tollerance);
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        return "generic";
    }

    protected String applyCatchAllRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        return CatchAllRecoveryMap.deviceIdOf(request.getUserAgent());
    }

    private boolean isBlankOrGeneric(String deviceID) {
        return StringUtils.isBlank((String)deviceID) || "generic".equals(deviceID);
    }

    static {
        $assertionsDisabled = !AbstractMatcher.class.desiredAssertionStatus();
    }

    private static final class CatchAllRecoveryMap {
        static final Map CATH_ALL_RECOVERY_MAP = new LinkedHashMap();

        private CatchAllRecoveryMap() {
        }

        public static String deviceIdOf(String userAgent) {
            String key = (String)CollectionUtils.find(CATH_ALL_RECOVERY_MAP.keySet(), (Predicate)UserAgentUtils.isContainedIn(userAgent));
            if (key != null) {
                return (String)CATH_ALL_RECOVERY_MAP.get(key);
            }
            return "generic";
        }

        static {
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/7.2", "opwv_v72_generic");
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/7", "opwv_v7_generic");
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/6.2", "opwv_v62_generic");
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/6", "opwv_v6_generic");
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/5", "upgui_generic");
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/4", "uptext_generic");
            CATH_ALL_RECOVERY_MAP.put("UP.Browser/3", "uptext_generic");
            CATH_ALL_RECOVERY_MAP.put("Series60", "nokia_generic_series60");
            CATH_ALL_RECOVERY_MAP.put("NetFront/3.0", "netfront_ver3");
            CATH_ALL_RECOVERY_MAP.put("ACS-NF/3.0", "netfront_ver3");
            CATH_ALL_RECOVERY_MAP.put("NetFront/3.1", "netfront_ver3_1");
            CATH_ALL_RECOVERY_MAP.put("ACS-NF/3.1", "netfront_ver3_1");
            CATH_ALL_RECOVERY_MAP.put("NetFront/3.2", "netfront_ver3_2");
            CATH_ALL_RECOVERY_MAP.put("ACS-NF/3.2", "netfront_ver3_2");
            CATH_ALL_RECOVERY_MAP.put("NetFront/3.3", "netfront_ver3_3");
            CATH_ALL_RECOVERY_MAP.put("ACS-NF/3.3", "netfront_ver3_3");
            CATH_ALL_RECOVERY_MAP.put("NetFront/3.4", "netfront_ver3_4");
            CATH_ALL_RECOVERY_MAP.put("NetFront/3.5", "netfront_ver3_5");
            CATH_ALL_RECOVERY_MAP.put("Windows CE", "ms_mobile_browser_ver1");
            CATH_ALL_RECOVERY_MAP.put("Mozilla/4.0", "generic_web_browser");
            CATH_ALL_RECOVERY_MAP.put("Mozilla/5.0", "generic_web_browser");
            CATH_ALL_RECOVERY_MAP.put("Mozilla/5.0", "generic_web_browser");
            CATH_ALL_RECOVERY_MAP.put("Mozilla/", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("ObigoInternetBrowser/Q03C", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("AU-MIC/2", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("AU-MIC-", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("AU-OBIGO/", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("Obigo/Q03", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("Obigo/Q04", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("ObigoInternetBrowser/2", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("Teleca Q03B1", "generic_xhtml");
            CATH_ALL_RECOVERY_MAP.put("Opera Mini/1", "opera_mini_ver1");
            CATH_ALL_RECOVERY_MAP.put("Opera Mini/2", "opera_mini_ver2");
            CATH_ALL_RECOVERY_MAP.put("Opera Mini/3", "opera_mini_ver3");
            CATH_ALL_RECOVERY_MAP.put("Opera Mini/4", "opera_mini_ver4");
            CATH_ALL_RECOVERY_MAP.put("DoCoMo", "docomo_generic_jap_ver1");
            CATH_ALL_RECOVERY_MAP.put("KDDI", "docomo_generic_jap_ver1");
        }
    }
}

