/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import net.sourceforge.wurfl.core.request.WURFLRequest;

public class BlackBerryMatcher
extends AbstractMatcher {
    public BlackBerryMatcher(Handler handler) {
        super(handler);
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        int position;
        String userAgent = request.getUserAgent();
        if (userAgent.startsWith("BlackBerry") && (position = userAgent.indexOf(47)) != -1 && position + 4 <= userAgent.length()) {
            String version = userAgent.substring(position + 1, position + 4);
            if (version.startsWith("2.")) {
                return "blackberry_generic_ver2";
            }
            if (version.startsWith("3.2")) {
                return "blackberry_generic_ver3_sub2";
            }
            if (version.startsWith("3.3")) {
                return "blackberry_generic_ver3_sub30";
            }
            if (version.startsWith("3.5")) {
                return "blackberry_generic_ver3_sub50";
            }
            if (version.startsWith("3.6")) {
                return "blackberry_generic_ver3_sub60";
            }
            if (version.startsWith("3.7")) {
                return "blackberry_generic_ver3_sub70";
            }
            if (version.startsWith("4.")) {
                return "blackberry_generic_ver4";
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No version matched, User-Agent: " + userAgent + " version: " + version));
            }
        }
        return "generic";
    }
}

