/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.wurfl.core.handlers.HandlersFactory;
import net.sourceforge.wurfl.core.handlers.classifiers.FilterChain;
import net.sourceforge.wurfl.core.handlers.classifiers.FilterChainFactory;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.handlers.matchers.MatcherChain;
import net.sourceforge.wurfl.core.handlers.matchers.MatcherChainFactory;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;

public class MatcherManager {
    private final MatcherChain matcherChain;
    private final FilterChain filterChain;

    public MatcherManager(WURFLModel model, FilterChain filterChain, MatcherChain matcherChain) {
        this.filterChain = filterChain;
        this.matcherChain = matcherChain;
        this.addFilteredDevices(model.getAllDevices());
    }

    public MatcherManager(WURFLModel model) {
        Map handlers = new HandlersFactory().create();
        this.filterChain = new FilterChainFactory(handlers).create();
        this.matcherChain = new MatcherChainFactory(handlers).create();
        this.addFilteredDevices(model.getAllDevices());
    }

    public String matchRequest(WURFLRequest request) {
        FilteredDevices filteredDevices = this.filterChain.getFilteredDevices(request.getUserAgent());
        return this.matcherChain.match(request, filteredDevices);
    }

    protected void addFilteredDevices(Set devices) {
        Iterator iterator = devices.iterator();
        while (iterator.hasNext()) {
            ModelDevice device = (ModelDevice)iterator.next();
            String userAgent = device.getUserAgent();
            String deviceId = device.getID();
            this.filterChain.filter(userAgent, deviceId);
        }
    }
}

