/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.matchers.AbstractMatcher;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.LDMatcher;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.RISMatcher;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.StringMatcher;
import net.sourceforge.wurfl.core.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.text.StrBuilder;

public class VodafoneMatcher
extends AbstractMatcher {
    private static final int VODAFONE_TOLLERANCE = 3;
    private Map toleranceMap = new HashMap();

    public VodafoneMatcher(Handler handler) {
        super(handler);
        this.initTolleranceMap();
    }

    private void initTolleranceMap() {
        this.toleranceMap.put("Nokia", new Tolerance("Nokia", "/"));
        this.toleranceMap.put("Sony", new Tolerance("Sony", "/"));
        this.toleranceMap.put("SEX1i", new Tolerance("SEX1i", "/"));
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        StringMatcherWithTolerance matcherWithTolerance = new StringMatcherWithTolerance(userAgent).invoke();
        StringMatcher matcher = matcherWithTolerance.getMatcher();
        int tolerance = matcherWithTolerance.getTolerance();
        this.log(userAgent, matcher, tolerance);
        return matcher.match(userAgentsSet, userAgent, tolerance);
    }

    private void log(String userAgent, StringMatcher matcher, int tolerance) {
        if (this.logger.isDebugEnabled()) {
            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Applying ");
            logBuilder.append((Object)matcher);
            logBuilder.append(tolerance).append(") UA: ");
            logBuilder.append(userAgent);
            this.logger.debug((Object)logBuilder.toString());
        }
    }

    private class StringMatcherWithTolerance {
        private String userAgent;
        private StringMatcher matcher;
        private int tollerance;

        public StringMatcherWithTolerance(String userAgent) {
            this.userAgent = userAgent;
        }

        public StringMatcher getMatcher() {
            return this.matcher;
        }

        public int getTolerance() {
            return this.tollerance;
        }

        public StringMatcherWithTolerance invoke() {
            this.tollerance = this.risTolerance(this.userAgent);
            if (this.tollerance > -1) {
                this.matcher = RISMatcher.INSTANCE;
            } else {
                this.matcher = LDMatcher.INSTANCE;
                this.tollerance = 3;
            }
            return this;
        }

        private int risTolerance(final String userAgent) {
            Tolerance risTolerance = (Tolerance)CollectionUtils.find(VodafoneMatcher.this.toleranceMap.values(), (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    String key = ((Tolerance)object).getKey();
                    return userAgent.indexOf(key) != 1;
                }
            });
            if (risTolerance != null) {
                return risTolerance.tolerance(userAgent);
            }
            return -1;
        }
    }

    private static final class Tolerance {
        private final String key;
        private final String risChar;

        private Tolerance(String key, String risChar) {
            this.key = key;
            this.risChar = risChar;
        }

        public int tolerance(String userAgent) {
            return StringUtils.indexOfOrLength(userAgent, this.risChar, StringUtils.indexOf(userAgent, this.key));
        }

        public String getKey() {
            return this.key;
        }

        public String getRisChar() {
            return this.risChar;
        }
    }
}

