/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers.strategy;

import java.util.Iterator;
import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.StringMatcher;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LDMatcher
implements StringMatcher {
    public static final LDMatcher INSTANCE = new LDMatcher();
    private static final Log LOG = LogFactory.getLog((Class)LDMatcher.class);

    private LDMatcher() {
    }

    public String getName() {
        return "LD";
    }

    public String match(SortedSet candidates, String needle, int tolerance) {
        this.trace(candidates, needle, tolerance);
        String match = null;
        int best = tolerance;
        int current = needle.length();
        Iterator cIt = candidates.iterator();
        while (cIt.hasNext() && current > 0) {
            String key = (String)cIt.next();
            if (Math.abs(key.length() - needle.length()) > tolerance || (current = LDMatcher.getLevenshteinDistance(key, needle, tolerance)) >= best && current != 0) continue;
            best = current;
            match = key;
        }
        return match;
    }

    private void trace(SortedSet candidates, String needle, int tolerance) {
        if (LOG.isTraceEnabled()) {
            StrBuilder sb = new StrBuilder("Applying LD(").append(tolerance).append(") on: ").append(needle).append(" using candidates: [");
            Iterator uIt = candidates.iterator();
            while (uIt.hasNext()) {
                sb.append(uIt.next());
                if (!uIt.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            LOG.trace((Object)sb.toString());
        }
    }

    public static int getLevenshteinDistance(String s, String t, int tolerance) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (tolerance == 0) {
            return s.equals(t) ? 0 : Integer.MAX_VALUE;
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
                if (i != j || d[i] <= tolerance + 3) continue;
                return Integer.MAX_VALUE;
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public String toString() {
        return this.getName();
    }
}

