/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.handlers.matchers.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.StringMatcher;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RISMatcher
implements StringMatcher {
    public static final RISMatcher INSTANCE = new RISMatcher();
    private static final Log LOG = LogFactory.getLog((Class)RISMatcher.class);

    private RISMatcher() {
    }

    public String getName() {
        return "RIS";
    }

    public String match(SortedSet candidates, String needle, int tolerance) {
        if (LOG.isTraceEnabled()) {
            StrBuilder sb = new StrBuilder("Applying RIS(");
            sb.append(tolerance).append(") on: ");
            sb.append(needle).append(" with candidates: [");
            Iterator uIt = candidates.iterator();
            while (uIt.hasNext()) {
                sb.append(uIt.next());
                if (!uIt.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            LOG.trace((Object)sb.toString());
        }
        String match = null;
        int needleLength = needle.length();
        ArrayList candidatesList = new ArrayList(candidates);
        String bestMatch = null;
        double bestDistance = -1.0;
        int low = 0;
        int high = candidatesList.size() - 1;
        while (low <= high && bestDistance < (double)needleLength) {
            int cmp;
            int mid = (low + high) / 2;
            String midCandidate = (String)candidatesList.get(mid);
            int distance = RISMatcher.getDistance(needle, midCandidate);
            if ((double)distance > bestDistance) {
                bestMatch = midCandidate;
                bestDistance = distance;
            }
            if ((cmp = midCandidate.compareTo(needle)) < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) break;
            high = mid - 1;
        }
        if (bestDistance >= (double)tolerance) {
            match = bestMatch;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found match: " + match));
            }
        }
        return match;
    }

    private static int getDistance(String t1, String t2) {
        int i;
        int t = Math.min(t1.length(), t2.length());
        for (i = 0; i < t && t1.charAt(i) == t2.charAt(i); ++i) {
        }
        return i;
    }

    public String toString() {
        return this.getName();
    }
}

