/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import java.io.Serializable;
import net.sourceforge.wurfl.core.resource.ModelDevices;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.text.StrBuilder;

public class ResourceData
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String version;
    private boolean patch;
    private ModelDevices devices;
    private transient String info;

    public ResourceData(String name, String version, ModelDevices devices) {
        this(name, version, false, devices);
    }

    public ResourceData(String name, String version, boolean patch, ModelDevices devices) {
        this.name = name;
        this.version = version;
        this.patch = patch;
        this.devices = devices;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isPatch() {
        return this.patch;
    }

    public String getInfo() {
        if (this.info == null) {
            StrBuilder infoBuilder = new StrBuilder();
            infoBuilder.append(this.patch ? "Patch" : "Root").append(":").append(this.name);
            if (StringUtils.isNotBlank((String)this.version)) {
                infoBuilder.append(":").append(this.version);
            }
            this.info = infoBuilder.toString();
        }
        return this.info;
    }

    public ModelDevices getDevices() {
        return new ModelDevices(this.devices);
    }

    public int compareTo(Object o) {
        ResourceData other = (ResourceData)o;
        CompareToBuilder cb = new CompareToBuilder();
        cb.append((Object)this.name, (Object)other.name).append((Object)this.version, (Object)other.version);
        return cb.toComparison();
    }

    public int hashCode() {
        HashCodeBuilder hb = new HashCodeBuilder(33, 55);
        hb.append((Object)this.name).append((Object)this.version);
        return hb.toHashCode();
    }

    public boolean equals(Object obj) {
        EqualsBuilder eb = new EqualsBuilder();
        eb.appendSuper(this.getClass().isInstance(obj));
        if (eb.isEquals()) {
            ResourceData other = (ResourceData)obj;
            eb.append((Object)this.getInfo(), (Object)other.getInfo());
        }
        return eb.isEquals();
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this);
        tb.append((Object)this.name).append((Object)this.version);
        return tb.toString();
    }
}

