/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.sourceforge.wurfl.core.resource.BadCapabilityGroupException;
import net.sourceforge.wurfl.core.resource.CapabilityConsistencyException;
import net.sourceforge.wurfl.core.resource.CircularHierarchyException;
import net.sourceforge.wurfl.core.resource.GenericNotDefinedException;
import net.sourceforge.wurfl.core.resource.GroupConsistencyException;
import net.sourceforge.wurfl.core.resource.HierarchyConsistencyException;
import net.sourceforge.wurfl.core.resource.InexistentCapabilityException;
import net.sourceforge.wurfl.core.resource.InexistentGroupException;
import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.ModelDevices;
import net.sourceforge.wurfl.core.resource.OrphanHierarchyException;
import net.sourceforge.wurfl.core.resource.UserAgentConsistencyException;
import net.sourceforge.wurfl.core.resource.UserAgentNotUniqueException;
import net.sourceforge.wurfl.core.resource.WURFLConsistencyException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WURFLConsistencyVerifier {
    private static final Log LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    private WURFLConsistencyVerifier() {
    }

    public static void verify(ModelDevices devices) throws WURFLConsistencyException {
        HashMap<String, ModelDevice> userAgents = new HashMap<String, ModelDevice>();
        HashSet<String> hierarchyVerifiedDevices = new HashSet<String>();
        LOG.debug((Object)"Verifing generic existence...");
        WURFLConsistencyVerifier.verifyGeneric(devices);
        Iterator devicesIterator = devices.iterator();
        while (devicesIterator.hasNext()) {
            ModelDevice device = (ModelDevice)devicesIterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Verifing device: " + device.getID()));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Verifing " + device.getID() + " userAgent..."));
            }
            WURFLConsistencyVerifier.verifyUserAgent(device, userAgents);
            userAgents.put(device.getUserAgent(), device);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Verifing " + device.getID() + " hierarchy..."));
            }
            WURFLConsistencyVerifier.verifyHierarchy(device, devices, hierarchyVerifiedDevices);
            hierarchyVerifiedDevices.add(device.getID());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Verifing " + device.getID() + " groups..."));
            }
            WURFLConsistencyVerifier.verifyGroups(device, devices);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Verifing " + device.getID() + " capabilities..."));
            }
            WURFLConsistencyVerifier.verifyCapabilities(device, devices);
        }
    }

    private static void verifyGeneric(ModelDevices devices) throws WURFLConsistencyException {
        if (!$assertionsDisabled && devices == null) {
            throw new AssertionError((Object)"devices is null");
        }
        if (!devices.containsId("generic")) {
            throw new GenericNotDefinedException();
        }
    }

    private static void verifyUserAgent(ModelDevice device, Map userAgents) throws UserAgentConsistencyException {
        if (!$assertionsDisabled && device == null) {
            throw new AssertionError((Object)"device is null");
        }
        if (!$assertionsDisabled && userAgents == null) {
            throw new AssertionError((Object)"userAgents is null");
        }
        if (userAgents.containsKey(device.getUserAgent())) {
            ModelDevice definingDevice = (ModelDevice)userAgents.get(device.getUserAgent());
            throw new UserAgentNotUniqueException(device, device.getUserAgent(), definingDevice);
        }
    }

    private static void verifyHierarchy(ModelDevice device, ModelDevices devices, Set hierarchyVerifiedDevicesId) throws HierarchyConsistencyException {
        if (!$assertionsDisabled && device == null) {
            throw new AssertionError((Object)"device is null");
        }
        if (!$assertionsDisabled && devices == null) {
            throw new AssertionError((Object)"devices is null");
        }
        if (!$assertionsDisabled && hierarchyVerifiedDevicesId == null) {
            throw new AssertionError((Object)"hierarchyVerifiedDevicesId is null");
        }
        ArrayList<String> hierarchy = new ArrayList<String>(10);
        String deviceId = device.getID();
        if (!$assertionsDisabled && StringUtils.isEmpty((String)deviceId)) {
            throw new AssertionError();
        }
        hierarchy.add(deviceId);
        while (!"generic".equals(deviceId)) {
            ModelDevice examineDevice = devices.getById(deviceId);
            String fallbackId = examineDevice.getFallBack();
            if (!$assertionsDisabled && StringUtils.isEmpty((String)fallbackId)) {
                throw new AssertionError();
            }
            if (hierarchyVerifiedDevicesId.contains(fallbackId)) {
                return;
            }
            if (!devices.containsId(fallbackId)) {
                throw new OrphanHierarchyException(hierarchy);
            }
            int hierarchyIndex = hierarchy.indexOf(fallbackId);
            if (hierarchyIndex != -1) {
                LinkedList circularHierarchy = new LinkedList(hierarchy.subList(hierarchyIndex, hierarchy.size()));
                throw new CircularHierarchyException(circularHierarchy);
            }
            hierarchy.add(fallbackId);
            deviceId = fallbackId;
        }
    }

    private static void verifyGroups(ModelDevice device, ModelDevices devices) throws GroupConsistencyException {
        if (!$assertionsDisabled && device == null) {
            throw new AssertionError((Object)"device is null");
        }
        if (!$assertionsDisabled && devices == null) {
            throw new AssertionError((Object)"devices is null");
        }
        ModelDevice generic = devices.getById("generic");
        Set deviceGroups = device.getGroups();
        Set genericGroups = generic.getGroups();
        Iterator gIt = deviceGroups.iterator();
        while (gIt.hasNext()) {
            String group = (String)gIt.next();
            if (genericGroups.contains(group)) continue;
            throw new InexistentGroupException(device, group);
        }
    }

    private static void verifyCapabilities(ModelDevice device, ModelDevices devices) throws CapabilityConsistencyException {
        if (!$assertionsDisabled && device == null) {
            throw new AssertionError((Object)"device is null");
        }
        if (!$assertionsDisabled && devices == null) {
            throw new AssertionError((Object)"devices is null");
        }
        if (!$assertionsDisabled && !devices.containsId("generic")) {
            throw new AssertionError((Object)"device do not containing generic");
        }
        ModelDevice generic = devices.getById("generic");
        Map genericCapabilities = generic.getCapabilities();
        Map deviceCapabilities = device.getCapabilities();
        Iterator dcnIt = deviceCapabilities.keySet().iterator();
        while (dcnIt.hasNext()) {
            String capabilityName = (String)dcnIt.next();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Verifing device: " + device.getID() + " capability: " + capabilityName));
            }
            if (!genericCapabilities.containsKey(capabilityName)) {
                throw new InexistentCapabilityException(device, capabilityName);
            }
            if (device.getGroupForCapability(capabilityName).equals(generic.getGroupForCapability(capabilityName))) continue;
            throw new BadCapabilityGroupException(device, capabilityName, device.getGroupForCapability(capabilityName), generic.getGroupForCapability(capabilityName));
        }
    }

    static {
        $assertionsDisabled = !WURFLConsistencyVerifier.class.desiredAssertionStatus();
        LOG = LogFactory.getLog((Class)WURFLConsistencyVerifier.class);
    }

    static class EqualsDeviceIdPredicate
    implements Predicate {
        private String id;

        public EqualsDeviceIdPredicate(String id) {
            this.id = id;
        }

        public boolean evaluate(Object object) {
            ModelDevice other = (ModelDevice)object;
            return this.id.equals(other.getID());
        }
    }
}

