/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.utils;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.LDMatcher;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.RISMatcher;
import org.apache.commons.lang.text.StrBuilder;

public final class StringUtils {
    private StringUtils() {
    }

    public static int firstSlash(String target) {
        return StringUtils.indexOfOrLength(target, "/");
    }

    public static int secondSlash(String target) {
        return StringUtils.ordinalIndexOfOrLength(target, "/", 2);
    }

    public static int firstSpace(String target) {
        return StringUtils.indexOfOrLength(target, " ");
    }

    public static int indexOfOrLength(String target, String needle) {
        return StringUtils.indexOfOrLength(target, needle, 0);
    }

    public static int indexOfOrLength(String target, String needle, int startIndex) {
        return StringUtils.ordinalIndexOfOrLength(target, needle, 1, startIndex);
    }

    public static int ordinalIndexOfOrLength(String target, String needle, int ordinal) {
        return StringUtils.ordinalIndexOfOrLength(target, needle, ordinal, 0);
    }

    public static int ordinalIndexOfOrLength(String target, String needle, int ordinal, int startIndex) {
        String workingTarget = org.apache.commons.lang.StringUtils.defaultString((String)target);
        int position = org.apache.commons.lang.StringUtils.ordinalIndexOf((String)(workingTarget = org.apache.commons.lang.StringUtils.substring((String)workingTarget, (int)(startIndex + 1))), (String)needle, (int)ordinal);
        position = position > 0 ? position + startIndex + 1 : target.length();
        return position;
    }

    public static String risMatch(SortedSet candidates, String needle, int tolerance) {
        return RISMatcher.INSTANCE.match(candidates, needle, tolerance);
    }

    public static String ldMatch(SortedSet candidates, String needle, int tolerance) {
        return LDMatcher.INSTANCE.match(candidates, needle, tolerance);
    }

    public static String hierarchyAsString(List hierarchy) {
        StrBuilder hierarchyBuilder = new StrBuilder();
        Iterator hIt = hierarchy.iterator();
        while (hIt.hasNext()) {
            hierarchyBuilder.append(hIt.next());
            if (!hIt.hasNext()) continue;
            hierarchyBuilder.append(" -> ");
        }
        return hierarchyBuilder.toString();
    }

    public static int indexOf(String userAgent, String key) {
        return org.apache.commons.lang.StringUtils.indexOf((String)userAgent, (String)key);
    }
}

