/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.text.StrBuilder;

public final class UserAgentUtils {
    public static final Pattern stripQuotePattern = Pattern.compile("\"");
    public static final Pattern nameSpacePattern = Pattern.compile("ns=(\\d*)");
    private static final List BOTS = new ArrayList();
    private static final List DESKTOP_BROWSERS = new ArrayList();
    private static final List MOBILE_BROWSERS = new ArrayList();

    private UserAgentUtils() {
    }

    public static String getUserAgent(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"The HttpServletRequest is null");
        String userAgent = "";
        userAgent = request.getParameter("UA") != null ? "" + request.getParameter("UA") : (request.getHeader("x-device-user-agent") != null ? "" + request.getHeader("x-device-user-agent") : "" + request.getHeader("User-Agent"));
        return userAgent;
    }

    public static String getUaProfile(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"The HttpServletRequest is null");
        String headerName = null;
        String uaProfile = null;
        if (request.getHeader("x-wap-profile") != null) {
            headerName = "x-wap-profile";
        } else if (request.getHeader("Profile") != null) {
            headerName = "Profile";
        } else if (request.getHeader("wap-profile") != null) {
            headerName = "wap-profile";
        } else if (request.getHeader("Opt") != null) {
            String optHeader = request.getHeader("Opt");
            String namespaceNumber = null;
            if (optHeader != null && optHeader.indexOf("ns=") != -1) {
                Matcher matcher = nameSpacePattern.matcher(optHeader);
                try {
                    namespaceNumber = matcher.group(1);
                    StrBuilder sb = new StrBuilder(namespaceNumber);
                    sb.append("-Profile");
                    headerName = sb.toString();
                }
                catch (Exception e) {
                    headerName = null;
                }
            }
        }
        if (headerName != null && headerName.trim().length() > 0) {
            uaProfile = request.getHeader(headerName);
        }
        if (uaProfile != null && uaProfile.trim().length() > 0) {
            stripQuotePattern.matcher(uaProfile).replaceAll("");
        }
        return uaProfile;
    }

    public static boolean isXhtmlRequester(HttpServletRequest httpRequest) {
        Validate.notNull((Object)httpRequest, (String)"HttpRequest is null");
        String acceptHeader = httpRequest.getHeader("accept");
        return acceptHeader != null && (acceptHeader.indexOf("application/vnd.wap.xhtml+xml") != -1 || acceptHeader.indexOf("application/xhtml+xml") != -1 || acceptHeader.indexOf("application/text+html") != -1);
    }

    public static boolean isMobileBrowser(String userAgent) {
        return CollectionUtils.find((Collection)MOBILE_BROWSERS, (Predicate)UserAgentUtils.isContainedIn(userAgent)) != null;
    }

    public static boolean isDesktopBrowser(String userAgent) {
        return CollectionUtils.find((Collection)DESKTOP_BROWSERS, (Predicate)UserAgentUtils.isContainedIn(userAgent)) != null;
    }

    public static boolean isBot(String userAgent) {
        return CollectionUtils.find((Collection)BOTS, (Predicate)UserAgentUtils.isContainedIn(userAgent)) != null;
    }

    public static Predicate isContainedIn(final String userAgent) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                return StringUtils.containsIgnoreCase((String)userAgent, (String)((String)object));
            }
        };
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(UserAgentUtils.class.getResourceAsStream("/net/sourceforge/wurfl/core/handlers/botskeywords.properties"));
            BOTS.addAll(properties.keySet());
            properties.clear();
            properties.load(UserAgentUtils.class.getResourceAsStream("/net/sourceforge/wurfl/core/handlers/desktopbrowserskeywords.properties"));
            DESKTOP_BROWSERS.addAll(properties.keySet());
            properties.clear();
            properties.load(UserAgentUtils.class.getResourceAsStream("/net/sourceforge/wurfl/core/handlers/mobilebrowserkeywords.properties"));
            MOBILE_BROWSERS.addAll(properties.keySet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

