/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import net.sourceforge.wurfl.core.resource.WURFLModel;

/**
 * Abstract implementation of {@link CapabilitiesHolderFactory}.
 * 
 * <p>
 * It references WURFLModel instance.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: AbstractCapabilitiesHolderFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class AbstractCapabilitiesHolderFactory implements
		CapabilitiesHolderFactory {

	/** Held WURFLModel */
	protected WURFLModel model;

	/**
	 * Constructor by WURFLModel.
	 * 
	 * @param model
	 *            The WURFLModel instance.
	 */
	public AbstractCapabilitiesHolderFactory(WURFLModel model) {
		this.model = model;
	}

}