/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;

/**
 * Abstract implementation of DeviceProvider.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: AbstractDeviceProvider.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class AbstractDeviceProvider implements DeviceProvider {

	/** The model used as backend */
	protected final WURFLModel model;

	/**
	 * Build DeviceProvider by WURFLModel.
	 * 
	 * @param model
	 *            The wurflModel used as backend.
	 */
	public AbstractDeviceProvider(WURFLModel model) {
		this.model = model;
	}

	/**
	 * This method get a ModelDevice from WURFLModel.
	 * 
	 * @param deviceId
	 *            Th requested device identifier.
	 * @return a ModelDevice identified by deviceId.
	 */
	protected ModelDevice getModelDevice(String deviceId)
			throws DeviceNotDefinedException {

		ModelDevice modelDevice = model.getDeviceById(deviceId);

		return modelDevice;
	}

}
