/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import java.util.Map;

/**
 * Holds the capabilities values for a single Device.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CapabilitiesHolder.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface CapabilitiesHolder {

	/**
	 * Return the capability value by capability name for single Device
	 * instance.
	 * 
	 * @param capabilityName
	 *            The name of capability to get value.
	 * @return The value of capability capabilityName
	 * @throws CapabilityNotDefinedException
	 *             If the capability capabilityName is not defined in WURFL.
	 */
	String getCapabilityValue(String capabilityName)
			throws CapabilityNotDefinedException;

	/**
	 * Returns all the capabilities for a single device.
	 * 
	 * @return Map containing couple name-value of single Device.
	 */
	Map getAllCapabilities();

}
