/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import net.sourceforge.wurfl.core.resource.ModelDevice;

/**
 * Factory for {@link CapabilitiesHolder} instances.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CapabilitiesHolderFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface CapabilitiesHolderFactory {

	/**
	 * Returns instance of CapabilitiesHolder.
	 * 
	 * @param modelDevice
	 *            The device root of {@link DefaultDevice} recipient of the
	 *            created CapabilitiesHolder.
	 * @return instance of CapabilitiesHolder holds capabilities defined by
	 *         <code>root</code> device and his parents.
	 */
	CapabilitiesHolder create(ModelDevice modelDevice);

}
