/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import java.util.Map;

/**
 * Loads the capabilities value for a single Device. Used by
 * DefaultCapabilitiesHolder to lazy load the capabilities.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CapabilitiesLoader.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface CapabilitiesLoader {

	/**
	 * This method load the capabilities in a Map of couple name, value.
	 * 
	 * @return Map instance containing the couples name, value of capabilities.
	 */
	Map loadCapabilities();
}
