/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import org.apache.commons.lang.text.StrBuilder;

/**
 * The capability x is not defined in WURFL.
 * 
 * <p>
 * This is a Exception thrown if the requested capability is not defined in
 * WURFL. Generally it mean the capability name is not right. THis Exception is
 * unchecked because it is a unrecoverable exception for the client.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CapabilityNotDefinedException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class CapabilityNotDefinedException extends WURFLRuntimeException {

	/** Serial */
	private static final long serialVersionUID = 1L;

	/** The name of capability not defined */
	private String capabilityName;

	/**
	 * Build a CapabilityNotDefinedException by the name of capability not
	 * defined.
	 * 
	 * @param capabilityName
	 *            The name of capability not defined.
	 */
	public CapabilityNotDefinedException(String capabilityName) {

		this(capabilityName, new StrBuilder("Capability: ").append(
				capabilityName).append(" is not defined in WURFL").toString());

	}

	/**
	 * Build a CapabilityNotDefinedException by the name of capability not
	 * defined.
	 * 
	 * @param capabilityName
	 *            The name of capability not defined.
	 * @param message
	 *            The message to display.
	 */
	public CapabilityNotDefinedException(String capabilityName, String message) {

		super(message);
		this.capabilityName = capabilityName;
	}

	/**
	 * Return the not defined capability name.
	 * 
	 * @return a string containing the capability name not defined.
	 */
	public String getCapabilityName() {
		return capabilityName;
	}

}
