/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * Constants used across WURFL API.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: Constants.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public final class Constants {

    private Constants(){}
    
	// Predefined devices *************************************************

	/** Generic device */
	public static final String GENERIC = "generic";

	/** Generic XHTML enabled device */
	public static final String GENERIC_XHTML = "generic_xhtml";

	/** Generic web browser */
	public static final String GENERIC_WEB_BROWSER = "generic_web_browser";

	// Parameters *********************************************************
	
	public static final String PARAMETER_UA = "UA";

	// Accept headers *****************************************************

	/** Accept header "application/vnd.wap.xhtml+xml" constant */
	public static final String ACCEPT_HEADER_VND_WAP_XHTML_XML = "application/vnd.wap.xhtml+xml";

	/** Accept header "application/xhtml+xml" constant */
	public static final String ACCEPT_HEADER_XHTML_XML = "application/xhtml+xml";

	/** Accept header "application/text+html" constant */
	public static final String ACCEPT_HEADER_TEXT_HTML = "application/text+html";

	// Capabilities names *************************************************

	/** Capability "xhtml_support_level" constant */
	public static final String CN_XHTML_SUPPORT_LEVEL = "xhtml_support_level";

	/** Capability "preferred_markup" constant */
	public static final String CN_PREFERRED_MARKUP = "preferred_markup";

	// Predefined logs ****************************************************

	/** Log name of undetected device log file */
	public static final String UNDETECTED_WURFL_DEVICES = "net.sourceforge.wurfl.core.UNDETECTED_WURFL_DEVICES";

	/** Log name of undetected device log file */
	public static final String DETECTED_WURFL_DEVICES = "net.sourceforge.wurfl.core.DETECTED_WURFL_DEVICES";

}
