/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import org.apache.commons.lang.Validate;

import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;

/**
 * {@link CapabilitiesHolderFactory} default implementation
 * <p>
 * Build instances of {@link DefaultCapabilitiesHolder}.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DefaultCapabilitiesHolderFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DefaultCapabilitiesHolderFactory extends
		AbstractCapabilitiesHolderFactory {

	/**
	 * Build DefaultCapabilitiesHolderFactory by WURFL model.
	 * 
	 * @param model
	 *            The WURFLModel used by this DefaultCapabilitiesHolderFactory.
	 */
	public DefaultCapabilitiesHolderFactory(WURFLModel model) {
		super(model);
	}

	/**
	 * {@inheritDoc}
	 */
	public CapabilitiesHolder create(ModelDevice modelDevice) {

		Validate.notNull(modelDevice, "modelDevice is null");

		return new DefaultCapabilitiesHolder(new DefaultCapabilitiesLoader(
				modelDevice, model));
	}

}
