/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * It is a default implementation of WURFLHolder interface, It is intended to
 * use as quick WURFL initialization method with no possibility of customize the
 * initialization process. It may be configured as lazy WURFLHolder that build
 * WURFL only when it is requested by application.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DefaultWURFLHolder.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DefaultWURFLHolder implements WURFLHolder {

	
	/** The held WURFLManager instance */
	private WURFLManager manager;

	/** The held WURFLUtils instance */
	private WURFLUtils utils;

	
	/**
	 * Default constructor.
	 */
	protected DefaultWURFLHolder() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * Build WURFLHolder by WURFLManager and WURFLUtils.
	 * 
	 * @param manager held WURFLManager
	 * @param utils held WURFLUtils
	 */
	public DefaultWURFLHolder(WURFLManager manager, WURFLUtils utils) {

		this.manager = manager;
		this.utils = utils;
	}


	/**
	 * Return a WURFLManager instance.
	 * 
	 * @return A WURFLManager instance.
	 */
	public WURFLManager getWURFLManager() {


		return manager;
	}

	/**
	 * Return the held WURFLUtils instance.
	 * 
	 * @return A WURFLUtils instance.
	 */
	public WURFLUtils getWURFLUtils() {

		return utils;
	}

}
