/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import java.util.Map;

/**
 * This is interface represent a device connected to the WURFL application.
 * 
 * <p>
 * It enable the user to obtain the capability of the actual device and other
 * useful info. It hides the WURFL repository structure to the other API parts.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: Device.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface Device {

	/**
	 * Return the WURFL id of this device
	 * 
	 * @return A string representing this device identifier.
	 */
	String getId();

	/**
	 * Return the user-agent string for this device as defined in WURFL.
	 * 
	 * @return A String containing the defined user-agent.
	 */
	String getUserAgent();

	/**
	 * Return a device's capability value.
	 * 
	 * @param name
	 *            The identifier of capability to get.
	 * @return The value of capability.
	 * @throws CapabilityNotDefinedException
	 *             If this device do not define the given capability.
	 */
	String getCapability(String name)
			throws CapabilityNotDefinedException;

	/**
	 * Returns a device's capabilities values by name Map.
	 * 
	 * @return Map<String, String> containing couples name-value of device's
	 *         capabilities.
	 */
	Map getCapabilities();

	/**
	 * Get the markUp handled by this device.
	 * 
	 * @return A MarkUp instance this device can handle.
	 */
	MarkUp getMarkUp();

}
