/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Device is not defined in WURFL.
 * 
 * <p>
 * Exception thrown if the requested device is not defined in the WURFL.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DeviceNotDefinedException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DeviceNotDefinedException extends WURFLRuntimeException {

	/** Serial */
	private static final long serialVersionUID = 1L;

	/** The not defined device id */
	private String deviceId;

	/**
	 * Constructor by device id and message to display.
	 * 
	 * @param deviceId
	 *            The device id not found.
	 */
	public DeviceNotDefinedException(String deviceId, String message) {
		
		super(message);
		this.deviceId = deviceId;
	}
	
	/**
	 * Constructor by device id.
	 * 
	 * @param deviceId
	 *            The device id not found.
	 */
	public DeviceNotDefinedException(String deviceId) {
		
		this(deviceId, new StrBuilder("Device: ").append(deviceId).append(" is not defined in WURFL").toString());
	}

	/**
	 * Return the not defined device id.
	 * 
	 * @return a String containing the not defined device id.
	 */
	public String getDeviceId() {
		return deviceId;
	}

}
