/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;


/**
 * Factory for Device instances.
 * <p>
 * Provide a method to get a Device from device identifier.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DeviceProvider.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface DeviceProvider {

	/**
	 * Returns the device identified by given id.
	 * 
	 * @param id
	 *            The identifier
	 * @return Device instance identified by id.
	 * @throws DeviceNotDefinedException
	 *             if Device with given identifier is not defined in WURFL.
	 */
	Device getDevice(String id) throws DeviceNotDefinedException;
	
}
