/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Exception thrown if the group requested is not defined in WURFL.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: GroupNotDefinedException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class GroupNotDefinedException extends WURFLRuntimeException {

	/** Serial */
	private static final long serialVersionUID = 1L;

	/** Group not defined */
	private String groupId;

	/**
	 * This constructor build this Exception by the not defined group identifier
	 * and message to display.
	 * 
	 * @param The
	 *            identifier of not defined group.
	 * @param message
	 *            The message to display.
	 */
	public GroupNotDefinedException(String groupId, String message) {

		super(message);
		this.groupId = groupId;
	}

	/**
	 * This constructor build this Exception by the not defined group
	 * identifier.
	 * 
	 * @param The
	 *            identifier of not defined group.
	 */
	public GroupNotDefinedException(String groupId) {

		this(groupId, new StrBuilder("Group: ").append(groupId).append(
				" is not defined in WURFL").toString());
	}

	/**
	 * Return the identifier of group object of this exception.
	 * 
	 * @return
	 */
	public String getGroupId() {
		return groupId;
	}

}
