/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import org.apache.commons.lang.Validate;

import net.sourceforge.wurfl.core.resource.ModelDevice;
import net.sourceforge.wurfl.core.resource.WURFLModel;

/**
 * Hierarchy {@link CapabilitiesHolderFactory} implementation.
 * 
 * <p>
 * Build instances of {@link HierarchyCapabilitiesHolder}.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: HierarchyCapabilitiesHolderFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class HierarchyCapabilitiesHolderFactory extends
		AbstractCapabilitiesHolderFactory {

	
	public HierarchyCapabilitiesHolderFactory(WURFLModel model) {
		super(model);
	}

	public CapabilitiesHolder create(ModelDevice modelDevice) {

		Validate.notNull(modelDevice, "modelDevice is null");
		
		return new HierarchyCapabilitiesHolder(model.getDeviceHierarchy(modelDevice));
	}

}
