/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * The device's markup.
 * 
 * <p>
 * This class represent a markup handled by a device in (WML, CHTML, advanced
 * XHTML, simple XHTML). It is a emulation of java5 enum implementation.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: MarkUp.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public final class MarkUp {

	/** WML markup */
	public static final MarkUp WML = new MarkUp("WML", -1);

	/** CHTML markup */
	public static final MarkUp CHTML = new MarkUp("CHTML", 0);

	/** Simple XHTML markup */
	public static final MarkUp XHTML_SIMPLE = new MarkUp("XHTML_SIMPLE", 1);

	/** Advanced XHTML markup */
	public static final MarkUp XHTML_ADVANCED = new MarkUp("XHTML_ADVANCED", 2);
	
	/** The int-value corresponding to the enum. */
	private int value;

	/** The string associated with the enum. */
	private String name;

	/**
	 * Convert to String.
	 * 
	 * @return String string representation.
	 */
	public String toString() {
		return name;
	}

	/**
	 * Get the int value.
	 * 
	 * @return int the int value of the markUp type.
	 */
	public int toValue() {
		return value;
	}

	/**
	 * Constructor by name and value.
	 * 
	 * @param n
	 *            The name of markUp.
	 * @param v
	 *            The integer value of markUp.
	 */
	private MarkUp(String n, int v) {
		name = n;
		value = v;
	}

}
