/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * This interface is used to resolve a device's MarkUp.
 * 
 * <p>
 * Different environments can use different MarkUp for the same device.
 * Implementing this interface permit to personalize resolved MarkUp.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: MarkupResolver.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface MarkupResolver {

	/**
	 * Resolve the MarkUp for the given Device.
	 * 
	 * @param device
	 *            The Device to resolve the MarkUp against.
	 * @return The MarkUp resolved for the given Device.
	 */
	MarkUp getMarkupForDevice(Device device);

}
