/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * A general checked Exception thrown by WURFL API.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class WURFLException extends Exception {

	/** Serial */
	private static final long serialVersionUID = 1L;

	/** Default constructor */
	public WURFLException() {
		super("Generic Exception in WURFL.");
	}

	/**
	 * Constructor by message.
	 * 
	 * @param message
	 *            A descriptive message of exception.
	 */
	public WURFLException(String message) {
		
		super(message);
	}

	/**
	 * Constructor by cause.
	 * 
	 * @param cause
	 *            The root cause of exception.
	 */
	public WURFLException(Throwable cause) {
		
		super(cause);
	}

	/**
	 * Constructor by message and cause.
	 * 
	 * @param message
	 *            A descriptive message of exception.
	 * @param cause
	 *            The root cause of exception.
	 */
	public WURFLException(String message, Throwable cause) {
		
		super(message, cause);
	}

}
