/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * This interface is responsible to hold a WURFLManager and
 * WURFLUtils instances. 
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLHolder.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLHolder {

	/**
	 * Return WURFLManager instance.
	 * 
	 * @return a WURFLManager instance.
	 */
	WURFLManager getWURFLManager();

	/**
	 * Return WURFLUtils instances.
	 * 
	 * @return A WURFLUtils instance.
	 */
	WURFLUtils getWURFLUtils();
}