/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import javax.servlet.http.HttpServletRequest;

import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * This is the WURFL interface used to do commons users operations as getting
 * Device instance from HTTP request or user-agent string.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLManager.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLManager {

	/**
	 * Return a Device instance from HttpServletRequest instance.
	 * 
	 * @param request
	 *            The HttpServletRequest to match.
	 */
	Device getDeviceForRequest(HttpServletRequest request);

	/**
	 * 
	 * Return a Device instance from WURFLRequest instance.
	 * 
	 * @param request
	 *            The WURFLRequest to match.
	 */
	Device getDeviceForRequest(WURFLRequest request);

	/**
	 * 
	 * Return a Device instance from user-agent String.
	 * 
	 * @param userAgent
	 *            The user-agent String to match.
	 */
	Device getDeviceForRequest(String userAgent);

}