/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

/**
 * THis is a RuntimeException thrown by WURFL API.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLRuntimeException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class WURFLRuntimeException extends RuntimeException {

	/** serial */
	private static final long serialVersionUID = 1L;

	/**
	 * Build WURFLRuntimeException.
	 */
	public WURFLRuntimeException() {
		super("WURFL unexpected exception");
	}

	/**
	 * Build WURFLRuntimeException from display message.
	 * 
	 * @param message
	 *            The message to display.
	 */
	public WURFLRuntimeException(String message) {
		super(message);
	}

	/**
	 * Build WURFLRuntimeException from display message and cause.
	 * 
	 * @param message
	 *            The message to display.
	 * @param cause
	 *            The cause of this exception.
	 */
	public WURFLRuntimeException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Build WURFLRuntimeException from cause.
	 * 
	 * @param cause
	 *            The cause of this exception.
	 */
	public WURFLRuntimeException(Throwable cause) {
		super("WURFL unexpected exception", cause);
	}

}
