/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core;

import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * This is the central interface of WURFL API. It define the main method of
 * WURFL API.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLService.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLService {

	/**
	 * Return a Device instance obtained by parsing the given
	 * WURFLRequest instance.
	 * 
	 * @param request
	 *            The WURFLRequest from which obtain the requester
	 *            device.
	 * @return A Device instance obtained from <code>request</code>
	 */
	Device getDeviceForRequest(WURFLRequest request);
}
