/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.cache;

/**
 * Provide cache feature.
 * 
 * <p>
 * Add support to some funny cache library implementing this interface.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CacheProvider.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface CacheProvider {

	/**
	 * Returns the cached item.
	 * 
	 * @param key
	 *            The cached item key.
	 * @return Cached Object, null if this cache does not contain it.
	 */
	Object get(Object key);

	/**
	 * Put an item in cache associated to a key.
	 * 
	 * @param key
	 *            The caching item key.
	 * @param value
	 *            The caching item.
	 */
	void put(Object key, Object value);

	/**
	 * Remove all items from cache.
	 */
	void clear();
}
