/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

/**
 * {@link CacheProvider}'s EhCache implementation.
 * 
 * <p>
 * Add EhCache support to WURFL api. for more info visit the <a
 * href="http://ehcache.sourceforge.net">EHCache site</a>
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: EhCacheProvider.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class EhCacheProvider implements CacheProvider {

	/** EhCache instance */
	private Cache cache;

	/** Default Constructor */
	public EhCacheProvider() {
		// Empty
	}

	/**
	 * Constructor by EhCache cache
	 * 
	 * @param cache
	 *            Cache instance.
	 */
	public EhCacheProvider(Cache cache) {
		this.cache = cache;
	}

	/**
	 * Returns the held cache.
	 * 
	 * @return Held {@link Cache} instance.
	 */
	public Cache getCache() {
		return cache;
	}

	/**
	 * Set the underlying cache instance.
	 * 
	 * @param cache The EhCache {@link Cache} instance.
	 */
	public void setCache(Cache cache) {
		this.cache = cache;
	}

	/**
	 * {@inheritDoc}
	 */
	public void clear() {
		cache.removeAll();
	}

	/**
	 * {@inheritDoc}
	 */
	public Object get(Object key) {

		Object stored = null;

		if (cache.isKeyInCache(key)) {
			Element item = cache.get(key);

			if (item != null) {
				// Can be expired
				stored = item.getObjectValue();
			}
		}

		return stored;

	}

	/**
	 * {@inheritDoc}
	 */
	public void put(Object key, Object value) {
		Element item = new Element(key, value);
		cache.put(item);
	}

}
