/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.cache;

/**
 * A Nop {@link CacheProvider} implementation.
 * 
 * <p>
 * This implementation is mainly used for testing purposes, it do not anything
 * and return always null.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: NullCacheProvider.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class NullCacheProvider implements CacheProvider {

	public void clear() {
		// Empty
	}

	/**
	 * @return null always.
	 */
	public Object get(Object key) {
		return null;
	}

	public void put(Object key, Object value) {
		// Empty
	}

}
