/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with "Alcatel" or "ALCATEL"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: AlcatelHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class AlcatelHandler extends Handler {

    public AlcatelHandler() {
    }

    public AlcatelHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks the given UA starts with "Alcatel" or "ALCATEL"
	 */
	public boolean canHandle(String userAgent) {
		return (userAgent.startsWith("Alcatel") || userAgent.startsWith("ALCATEL"));
	}
}
