/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;
import net.sourceforge.wurfl.core.utils.Predicates;

/**
 * Intercept all UAs containing "iPhone" or "iPod" or iPad
 *
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: AppleHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class AppleHandler extends Handler {

    private static final List APPLE_KEYOWRDS = Arrays.asList(new String[]{"iPhone", "iPod", "iPad"});

    public AppleHandler() {
    }

    public AppleHandler(UserAgentNormalizer normalizer) {
        super(normalizer);
    }

    /**
     * Checks given UA contains "iPhone" or "iPod" or iPad
     */
    public boolean canHandle(final String userAgent) {
        return CollectionUtils.exists(APPLE_KEYOWRDS, Predicates.isContainedIn(userAgent));
    }

    

}
