/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with "BenQ" or "BENQ"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: BenQHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class BenQHandler extends Handler {

    public BenQHandler() {
    }

    public BenQHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks the given UA starts with "BenQ" or "BENQ"
	 */
	public boolean canHandle(String userAgent) {
		return (userAgent.startsWith("BENQ") || userAgent.startsWith("BenQ"));
	}

}
