/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;
import net.sourceforge.wurfl.core.utils.UserAgentUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 */
public class BotHandler extends Handler {

    private final Set BOTS = new HashSet();
    private static final String BOT_KEYWORDS = "/net/sourceforge/wurfl/core/handlers/botskeywords.properties";

    public BotHandler() {
        BOTS.addAll(UserAgentUtils.keys(BOT_KEYWORDS));
    }

    public BotHandler(UserAgentNormalizer normalizer) {
        super(normalizer);
        BOTS.addAll(UserAgentUtils.keys(BOT_KEYWORDS));        
    }

    public boolean canHandle(String userAgent) {
        return CollectionUtils.find(BOTS, UserAgentUtils.isContainedIn(userAgent)) != null;
    }

}
