/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all user-agent.
 *
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CatchAllHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class CatchAllHandler extends Handler {

    public CatchAllHandler() {
    }

    public CatchAllHandler(UserAgentNormalizer normalizer) {
        super(normalizer);
    }

    /**
     * Returns always true.
     */
    public boolean canHandle(String userAgent) {
        return true;
    }

}
