/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs containing "Firefox" and not are mobile browsers.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: FirefoxHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class FirefoxHandler extends Handler {

    public FirefoxHandler() {
    }

    public FirefoxHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	private static final String FIREFOX = "Firefox";

	/**
	 * Checks the given UA is not mobile browser and contains "Firefox".
	 */
	public boolean canHandle(String userAgent) {
		return !isMobileBrowser(userAgent) && StringUtils.contains(userAgent, FIREFOX);
	}

}
