/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.NullNormalizer;
import net.sourceforge.wurfl.core.utils.UserAgentUtils;

/**
 * User-agent handler.
 * 
 * <p>
 * Used by matchers and classifiers to intercept the devices. 
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @version $Id: Handler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class Handler {
	
	private UserAgentNormalizer normalizer;

    public Handler() {
        this(NullNormalizer.INSTANCE);
    }

    public Handler(UserAgentNormalizer normalizer) {
		this.normalizer = normalizer;
	}

	/**
	 * Test if this Handler handles the given user-agent.
	 * 
	 * @param userAgent
	 *            The user-agent to probe.
	 * @return True if this user-agent can be handled, false otherwise.
	 */
	public abstract boolean canHandle(String userAgent);
	
	public String normalize(String userAgent) {
		return normalizer.normalize(userAgent);
	}
	
	
	/**
	 * 
	 * @param userAgent
	 * @return
	 */
	public boolean isMobileBrowser(String userAgent) {
        return UserAgentUtils.isMobileBrowser(userAgent);		
	}
	
}
