/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.collections.map.UnmodifiableMap;

import net.sourceforge.wurfl.core.request.normalizer.specific.AndroidNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.ChromeNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.FirefoxNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.KonquerorNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.MSIENormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.OperaNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.specific.SafariNormalizer;

/**
 * A factory for user-agent {@link Handler}.
 * 
 * <p>
 * This class build a {@link Map} of user-agent {@link Handler} by a key.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: HandlersFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class HandlersFactory {

	private static Map handlers = new LinkedHashMap();

	static {
		ChromeNormalizer chromeNormalizer = new ChromeNormalizer();
		KonquerorNormalizer konquerorNormalizer = new KonquerorNormalizer();
		SafariNormalizer safariNormalizer = new SafariNormalizer();
		FirefoxNormalizer firefoxNormalizer = new FirefoxNormalizer();
		MSIENormalizer msieNormalizer = new MSIENormalizer();


		handlers.put(HandlerConstants.NOKIA, new NokiaHandler());

        handlers.put(HandlerConstants.ANDROID, new AndroidHandler(new AndroidNormalizer()));        
		handlers.put(HandlerConstants.SONY_ERICSSON, new SonyEricssonHandler());


		handlers.put(HandlerConstants.MOTOROLA, new MotorolaHandler());
		handlers.put(HandlerConstants.BLACKBERRY, new BlackBerryHandler());

		handlers.put(HandlerConstants.SIEMENS, new SiemensHandler());
		handlers.put(HandlerConstants.SAGEM, new SagemHandler());

		handlers.put(HandlerConstants.SAMSUNG, new SamsungHandler());
		handlers.put(HandlerConstants.PANASONIC, new PanasonicHandler());

		handlers.put(HandlerConstants.NEC, new NecHandler());
		handlers.put(HandlerConstants.QTEK, new QtekHandler());

		handlers.put(HandlerConstants.MITSUBISHI, new MitsubishiHandler());
		handlers.put(HandlerConstants.PHILIPS, new PhilipsHandler());

		handlers.put(HandlerConstants.LG, new LGHandler());
		handlers.put(HandlerConstants.APPLE, new AppleHandler());

		handlers.put(HandlerConstants.KYOCERA, new KyoceraHandler());
		handlers.put(HandlerConstants.ALCATEL, new AlcatelHandler());

		handlers.put(HandlerConstants.SHARP, new SharpHandler());
		handlers.put(HandlerConstants.SANYO, new SanyoHandler());

		handlers.put(HandlerConstants.BENQ, new BenQHandler());
		handlers.put(HandlerConstants.PANTECH, new PantechHandler());

		handlers.put(HandlerConstants.TOSHIBA, new ToshibaHandler());
		handlers.put(HandlerConstants.GRUNDIG, new GrundigHandler());

		handlers.put(HandlerConstants.HTC, new HTCHandler());

        handlers.put(HandlerConstants.BOT, new BotHandler());        
		handlers.put(HandlerConstants.SPV, new SPVHandler());

		handlers.put(HandlerConstants.WINDOWS_CE, new WindowsCEHandler());
		handlers.put(HandlerConstants.PORTALMMM, new PortalmmmHandler());

		handlers.put(HandlerConstants.DOCOMO, new DoCoMoHandler());
		handlers.put(HandlerConstants.KDDDI, new KDDIHandler());

        handlers.put(HandlerConstants.VODAFONE, new VodafoneHandler());
        

		handlers.put(HandlerConstants.OPERA_MINI, new OperaMiniHandler());
		
		handlers.put(HandlerConstants.CHROME, new ChromeHandler(chromeNormalizer));
		handlers.put(HandlerConstants.AOL, new AOLHandler());
		handlers.put(HandlerConstants.OPERA, new OperaHandler());
		handlers.put(HandlerConstants.KONQUEROR, new KonquerorHandler(konquerorNormalizer));
		handlers.put(HandlerConstants.SAFARI, new SafariHandler(safariNormalizer));
		handlers.put(HandlerConstants.FIREFOX, new FirefoxHandler(firefoxNormalizer));
		handlers.put(HandlerConstants.MSIE, new MSIEHandler(msieNormalizer));
		
		handlers.put(HandlerConstants.CATCH_ALL, new CatchAllHandler());
	}

	/**
	 * Return the {@link Map} containig the {@link Handler}s. It is a
	 * {@link UnmodifiableMap}.
	 * 
	 * @return A {@link UnmodifiableMap} containig the {@link Handler} by
	 *         handlers key.
	 */
	public Map create() {
		return Collections.unmodifiableMap(handlers);
	}
}